<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

namespace Altum;

defined('ALTUMCODE') || die();

class CustomHooks {

    public static function user_finished_registration($data = []) {

    }

    public static function user_delete($data = []) {

        /* Delete the potentially uploaded files on preference settings */
        if($data['user']->preferences->white_label_logo_light) {
            Uploads::delete_uploaded_file($data['user']->preferences->white_label_logo_light, 'users');
        }

        if($data['user']->preferences->white_label_logo_dark) {
            Uploads::delete_uploaded_file($data['user']->preferences->white_label_logo_dark, 'users');
        }

        if($data['user']->preferences->white_label_favicon) {
            Uploads::delete_uploaded_file($data['user']->preferences->white_label_favicon, 'users');
        }

        $user_id = $data['user']->user_id;

        /* Delete everything related to the domain that the user owns */
        $result = database()->query("SELECT `link_id` FROM `links` WHERE `user_id` = {$user_id}");
        while($link = $result->fetch_object()) {
            (new \Altum\Models\Link())->delete($link->link_id);
        }

        /* Delete everything related to the qr codes that the user owns */
        if(settings()->codes->qr_codes_is_enabled) {
            $result = database()->query("SELECT `qr_code_id` FROM `qr_codes` WHERE `user_id` = {$user_id}");

            while($qr_code = $result->fetch_object()) {
                (new \Altum\Models\QrCode())->delete($qr_code->qr_code_id);
            }
        }

        if(\Altum\Plugin::is_installed('aix')) {
            /* Delete everything related to the images that the user owns */
            $result = database()->query("SELECT `image_id`, `image` FROM `images` WHERE `user_id` = {$user_id}");

            while($image = $result->fetch_object()) {
                \Altum\Uploads::delete_uploaded_file($image->image, 'images');

                /* Delete the resource */
                db()->where('image_id', $image->image_id)->delete('images');
            }

            /* Delete everything related to the syntheses that the user owns */
            $result = database()->query("SELECT `synthesis_id`, `file` FROM `syntheses` WHERE `user_id` = {$user_id}");

            while($synthesis = $result->fetch_object()) {
                \Altum\Uploads::delete_uploaded_file($synthesis->file, 'syntheses');

                /* Delete the resource */
                db()->where('synthesis_id', $synthesis->synthesis_id)->delete('images');
            }
        }

    }

}
